@ECHO OFF
setlocal

REM Doki Doki auto-patcher

REM Variables
SET DOKIDOKI_REGKEY=HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 698780
SET DOKIDOKI_REGVALUE=InstallLocation
SET DIRECTORY_NAME=Yarashii - Doki Doki Literature Club! Patch FR
SET PATCH_FILENAME=%DIRECTORY_NAME%.zip
SET PATCH_DOWNLOAD_URL=https://ddl.yarashii.fr/Visual Novel/%PATCH_FILENAME%
SET EXIT=0

REM Check Windows version
FOR /f "tokens=4-5 delims=. " %%i IN ('ver') do SET WIN_VERSION=%%i.%%j

REM Check if game is installed (steam)
IF "%WIN_VERSION%" == "10.0" (ECHO [33m1/ V�rification de l'installation du jeu sur le syst�me[0m) ELSE (ECHO 1/ V�rification de l'installation du jeu sur le syst�me)
reg query "%DOKIDOKI_REGKEY%" /v "%DOKIDOKI_REGVALUE%" >nul 2>&1 || (ECHO Jeu non detect� & SET EXIT=1 & GOTO :sortie)
ECHO.

REM Get install path
IF "%WIN_VERSION%" == "10.0" (ECHO [33m2/ R�cuperation du chemin d'installation[0m) ELSE (ECHO 2/ R�cuperation du chemin d'installation)
FOR /F "skip=2 tokens=2,*" %%A IN ('reg query "%DOKIDOKI_REGKEY%" /v "%DOKIDOKI_REGVALUE%"') DO SET "InstallPath=%%B"
ECHO.

REM Download and unzip patch in current directory
cd /d %~dp0
IF "%WIN_VERSION%" == "10.0" (ECHO [33m3/ T�l�chargement du patch FR[0m) ELSE (ECHO 3/ T�l�chargement du patch FR)
aria2\aria2c.exe -c "%PATCH_DOWNLOAD_URL%"
ECHO.

IF "%WIN_VERSION%" == "10.0" (ECHO [33m4/ Extraction du patch FR[0m) ELSE (ECHO 4/ Extraction du patch FR)
7zip\App\7-zip\7z.exe x "%PATCH_FILENAME%"
ECHO.

REM Copy patch files to game folder
IF "%WIN_VERSION%" == "10.0" (ECHO [33m5/ Installation du patch FR[0m) ELSE (ECHO 5/ Installation du patch FR)
xcopy "%DIRECTORY_NAME%" "%InstallPath%" /e /r /i /y
ECHO.

REM Check if patch successfully installed
IF "%WIN_VERSION%" == "10.0" (ECHO [33m6/ V�rification de l'installation du patch[0m) ELSE (ECHO 6/ V�rification de l'installation du patch)
IF EXIST "%InstallPath%\characters\Pas lire avant cr�dits\" (
    IF "%WIN_VERSION%" == "10.0" (ECHO [32mSucces[0m) ELSE (ECHO Succes)
    
) ELSE (
    IF "%WIN_VERSION%" == "10.0" (ECHO [41mPatch non detect�[0m) ELSE (ECHO Patch non detect�)
    SET EXIT=1
)
ECHO.

GOTO :sortie

:sortie
REM Clean temp files
IF "%WIN_VERSION%" == "10.0" (ECHO [33m7/ Nettoyage des fichiers temporaires[0m) ELSE (ECHO 7/ Nettoyage des fichiers temporaire)
DEL /s /q "%DIRECTORY_NAME%\*" >nul 2>&1
RMDIR /s /q "%DIRECTORY_NAME%\" >nul 2>&1

SET /p CONFIRM=Voulez-vous supprimer l'archive du patch ? (O/[N])?
IF /i "%CONFIRM%" == "O" (DEL /s /q "%PATCH_FILENAME%" >nul 2>&1)
ECHO.
PAUSE
exit /b %EXIT%
